<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Response;
use backend\models\Attachments;
use common\models\Files;
use yii\db\Expression;
use yii\helpers\Json;
class UploadController extends Controller
{
	public function actionIndex()
    {
    	if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $group = (isset(Yii::$app->request->queryParams['group'])) ? Yii::$app->request->queryParams['group'] : '';

        if (isset($_POST)) {
        	if (isset($_FILES)){
        		$files= Attachments::SaveTempAttachments($_FILES);
                $result = ['files'=>$files];
                
                foreach ($result as $k => $val) {
                	foreach ($result[$k] as $key => $value) {
                        $i = 0;
                		if($value['type']!='bat' && $value['type']!='pws' && $value['type']!='ps1' && $value['type']!='csv'){ // bat & pws are not keeping
                            //if(!Files::findOne(['hashmd5'=>$value['hash']])){
                
    		            	$m = new Files();
    		            	$m->storedfilename = $value['fileName'];
    		            	$m->filetype = $value['type'];
    		            	$m->size = (int)$value['size'];
    		            	$m->filename = $value['originalName'];
    		            	$m->created_at = new Expression('NOW()');
    		            	$m->admin_id = Yii::$app->user->identity->id;
                            $m->hashmd5 = $value['hash'];
                            $m->group = $group;
    		            	$m->save(false);

                            $result['files'][$i]['id'] = $m->id;
                            $result['files'][$i]['uploaded'] = $m->created_at;
                            
                            $i++;

                            Yii::info('Admin '. Yii::$app->user->identity->login . ' upload file '.$m->filename, $category = 'admininfo');
    		            }
    	            }
                }
//print_r($result);die();
                
                Yii::$app->response->format = trim(Response::FORMAT_JSON);
                return $result;
            }
        }
    }
}